// SendReceiveHIDDlg.h : header file
//

/*

This source code file is the property of GN Netcom A/S and is to be treated as
confidential by the party to whom it has been submitted by GN Netcom A/S and is
not to be disclosed to any third party without the specific prior written 
permission of GN Netcom A/S.

GN Netcom A/S make no guarantees as to the functionality of this software product, 
and no warranty is implied. 
Users may install and use the software at their own risk. 
No end-user support will be provided.
 
*/


#include "afxwin.h"
#if !defined(AFX_SENDRECEIVEHIDDLG_H__0A639E66_A0A6_4A85_A516_E541C713B6D1__INCLUDED_)
#define AFX_SENDRECEIVEHIDDLG_H__0A639E66_A0A6_4A85_A516_E541C713B6D1__INCLUDED_

extern "C" {
// Declare the C libraries used
#include "Windows.h"
#include "setupapi.h"
#include "hidsdi.h"
}

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "LedButton.h"

/////////////////////////////////////////////////////////////////////////////
// CSendReceiveHIDDlg dialog

class CSendReceiveHIDDlg : public CDialog
{
// Construction
public:
	CSendReceiveHIDDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CSendReceiveHIDDlg)
	enum { IDD = IDD_SENDRECEIVEHID_DIALOG };
	CButton	m_RedButton;
	CButton	m_GreenButton;
	CString	m_VolumeStaticString;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSendReceiveHIDDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

	char m_bytes[2];

// Implementation
protected:
	HICON m_hIcon;

	BOOL GreenLedOn;
	BOOL RedLedOn;
	int ButtonBState;

	HANDLE RHandle, SHandle;
	CWinThread *pReceiveThread;
	CWinThread *pBlinkThread;
	CWinThread *pCleanVolume;
	CWinThread *pCleanHID;

	BOOL bReadingHID, bWriteHIDReq, bWriteHIDReqGranted;
	HIDP_CAPS Capabilities;
	PHIDP_PREPARSED_DATA HidPreparsedData;
	HIDD_ATTRIBUTES	Attributes;

	ULONG  UsageLength;
	PUSAGE_AND_PAGE  pButtonList;

	CString FirstButStr;
	HANDLE OpenUSBinterface();

 	static UINT ReceiveFunction( LPVOID pParam );
    void SetDeviceAttachState(int AttachState );
    void ShowUsage(char *bytes, unsigned long BytesRead);
	void WriteHid(char *bytes);

	LRESULT OnHidInput( WPARAM wParam, LPARAM lParam  );
	LRESULT OnClearStrings( WPARAM wParam, LPARAM lParam );
	LRESULT OnSetLED( WPARAM wParam, LPARAM lParam );
    LRESULT OnSetSideTone( WPARAM wParam, LPARAM lParam );
	LRESULT GetHid( WPARAM wParam, LPARAM lParam );

	// Generated message map functions
	//{{AFX_MSG(CSendReceiveHIDDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnSendHidButton();
	afx_msg void OnGreenbutton();
	afx_msg void OnRedbutton();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	BOOL OnDeviceChange(UINT nEventType, DWORD_PTR dwData);

private:

    #define GN_VENDOR_ID           0x0B0E 

    #define GB_GREEN_LED_ON        0x01
    #define GB_GREEN_LED_OFF       0x02
    #define WB_WHITE_LED_ON        0x03
    #define WB_WHITE_LED_OFF       0x04
    #define WB_BLUE_LED_ON         0x05
    #define WB_BLUE_LED_OFF        0x06
    #define WB_GREEN_LED_ON        0x07
    #define WB_GREEN_LED_OFF       0x08
    #define RB_RED_LED_ON          0x09
    #define RB_RED_LED_OFF         0x0A
    #define SIDETONE_DISABLE       0x23
    #define SIDETONE_ENABLE        0x24

    #define BLUE_BUT_MAIN_VOL_DOWN 0x01
    #define BLUE_BUT_MAIN_VOL_UP   0x02
    #define MORE_BUT_REPEAT        0x04
    #define GREEN_BUT_PRESSED      0x08
    #define WHITE_BUT_PRESSED      0x10
    #define RED_BUT_PRESSED        0x20
    #define GREEN_BUT_PRESSED_SEC  0x0C
    #define WHITE_BUT_PRESSED_SEC  0x14
    #define RED_BUT_PRESSED_SEC    0x24
    #define BLUE_BUT_ALTR_VOL_DOWN 0x40
    #define BLUE_BUT_ALTR_VOL_UP   0x80

	#define USAGE_PAGE_TELEPHONY   0x0B
	#define USAGE_PAGE_CONSUMER    0x0C

	#define USAGE_ID_HOOKSWITCH    0x20
	#define USAGE_ID_VOICEMAIL     0x70
	#define USAGE_ID_PHONE_MUTE    0x2F
	#define USAGE_ID_VOLUME_UP     0xE9
	#define USAGE_ID_VOLUME_DOWN   0xEA
	#define USAGE_ID_FIRE          0x107

	#define WM_SET_LED             1030 
	#define WM_HID_INPUT           1031 
	#define WM_CLEAR_STRINGS       1032 
	#define WM_SET_SIDETONE        1033 

    typedef enum { GN_DEVICE_ATTACHED,
                   GN_DEVICE_DEATTACHED,
                   GN_DEVICE_NOT_ATTACHED};

    typedef enum { CLEAR_EVENT_STRING,
		           CLEAR_VALUE_STRINGS};

	static UINT BlinkAllLEDs( LPVOID pParam );
	static UINT CleanVolumeString( LPVOID pParam );
	static UINT CleanHIDString( LPVOID pParam );
	void Deallocate();
	void StartCleanVolumeThread();
	void StartCleanHIDThread();
public:
	afx_msg void OnBnClickedTogglebutton();
	CLedButton m_GreenLED;
	CLedButton m_RedLED;
	CLedButton m_BlueLED;
	CLedButton m_WhiteLED;
	CLedButton m_GreenLED2;
	afx_msg void OnBnClickedOk();
	CString m_SendEditHIDStr;
	afx_msg void OnEnChangeSendedit();
	CString m_VendorID;
	CString m_ProductID;
	CString m_BCD_Device;
	CString m_ReceiveReport;
	CString m_Usage;
	CButton m_ToggleButton;
	CButton m_SendHid;
	CEdit m_SendEditHID;
	CString m_UsagePage;
	afx_msg void OnBnClickedSidetone();
	BOOL m_DisableSidetone;
	CButton m_SideToneCtrl;
	afx_msg void OnClose();
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SENDRECEIVEHIDDLG_H__0A639E66_A0A6_4A85_A516_E541C713B6D1__INCLUDED_)
