// SendReceiveHIDDlg.cpp : implementation file
//

/*

This source code file is the property of GN Netcom A/S and is to be treated as
confidential by the party to whom it has been submitted by GN Netcom A/S and is
not to be disclosed to any third party without the specific prior written 
permission of GN Netcom A/S.

GN Netcom A/S make no guarantees as to the functionality of this software product, 
and no warranty is implied. 
Users may install and use the software at their own risk. 
No end-user support will be provided.
 
*/


#include "stdafx.h"
#include "SendReceiveHID.h"
#include "SendReceiveHIDDlg.h"

extern "C" {
// Declare the C libraries used
#include "Windows.h"
#include "setupapi.h"
#include "hidsdi.h"
#include ".\sendreceivehiddlg.h"
}

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSendReceiveHIDDlg dialog

CSendReceiveHIDDlg::CSendReceiveHIDDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSendReceiveHIDDlg::IDD, pParent)

	, m_SendEditHIDStr(_T(""))
	, m_VendorID(_T(""))
	, m_ProductID(_T(""))
	, m_BCD_Device(_T(""))
	, m_ReceiveReport(_T(""))
	, m_Usage(_T(""))
	, m_UsagePage(_T(""))
	, m_DisableSidetone(FALSE)
{
	//{{AFX_DATA_INIT(CSendReceiveHIDDlg)
	m_VolumeStaticString = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSendReceiveHIDDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSendReceiveHIDDlg)
	DDX_Control(pDX, IDC_REDBUTTON, m_RedButton);
	DDX_Control(pDX, IDC_GREENBUTTON, m_GreenButton);
	DDX_Text(pDX, IDC_VOLUMESTATIC, m_VolumeStaticString);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_GreenLED, m_GreenLED);
	DDX_Control(pDX, IDC_RedLED, m_RedLED);
	DDX_Control(pDX, IDC_WhiteLED, m_WhiteLED);
	DDX_Control(pDX, IDC_BleuLED, m_BlueLED);
	DDX_Control(pDX, IDC_GreenLED2, m_GreenLED2);
	DDX_Text(pDX, IDC_SENDEDIT, m_SendEditHIDStr);
	DDV_MaxChars(pDX, m_SendEditHIDStr, 2);
	DDX_Text(pDX, IDC_VENDOR_ID, m_VendorID);
	DDX_Text(pDX, IDC_PRODUCT_ID, m_ProductID);
	DDX_Text(pDX, IDC_BCD_DEVICE, m_BCD_Device);
	DDX_Text(pDX, IDC_RECEIVE_REPORT, m_ReceiveReport);
	DDX_Text(pDX, IDC_RECEIVEEDIT, m_Usage);
	DDX_Control(pDX, IDC_TOGGLEBUTTON, m_ToggleButton);
	DDX_Control(pDX, IDC_SENDHIDBUTTON, m_SendHid);
	DDX_Control(pDX, IDC_SENDEDIT, m_SendEditHID);
	DDX_Text(pDX, IDC_USAGEPAGE, m_UsagePage);
	DDX_Check(pDX, IDC_SIDETONE, m_DisableSidetone);
	DDX_Control(pDX, IDC_SIDETONE, m_SideToneCtrl);
}

BEGIN_MESSAGE_MAP(CSendReceiveHIDDlg, CDialog)
	//{{AFX_MSG_MAP(CSendReceiveHIDDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_SENDHIDBUTTON, OnSendHidButton)
	ON_BN_CLICKED(IDC_GREENBUTTON, OnGreenbutton)
	ON_BN_CLICKED(IDC_REDBUTTON, OnRedbutton)
	//}}AFX_MSG_MAP
	ON_WM_DEVICECHANGE()
	ON_MESSAGE(WM_INPUT, GetHid)
	ON_MESSAGE(WM_SET_LED, OnSetLED)	
	ON_MESSAGE(WM_SET_SIDETONE, OnSetSideTone)
	ON_MESSAGE(WM_HID_INPUT, OnHidInput)
	ON_MESSAGE(WM_CLEAR_STRINGS, OnClearStrings)
	ON_BN_CLICKED(IDC_TOGGLEBUTTON, OnBnClickedTogglebutton)
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
	ON_EN_CHANGE(IDC_SENDEDIT, OnEnChangeSendedit)
	ON_BN_CLICKED(IDC_SIDETONE, OnBnClickedSidetone)
	ON_WM_CLOSE()
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSendReceiveHIDDlg message handlers

BOOL CSendReceiveHIDDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	this->m_GreenLED.SetImage( IDB_GREENBUTTON, 15 );
	this->m_RedLED.SetImage( IDB_REDBUTTON, 15 );
	this->m_WhiteLED.SetImage( IDB_WHITEBUTTON, 15 );
	this->m_BlueLED.SetImage( IDB_BLUEBUTTON, 15 );
	this->m_GreenLED2.SetImage( IDB_GREENBUTTON, 15 );

	GreenLedOn = FALSE;
	RedLedOn = FALSE;
	ButtonBState = 0;
	HidPreparsedData = NULL;
	RHandle = NULL;//OpenUSBinterface("GN");
	SHandle = NULL;//OpenUSBinterface("GN");
	pBlinkThread = NULL;
	pReceiveThread = NULL;
	pCleanVolume = NULL;
	pCleanHID = NULL;
	pButtonList = NULL;
    FirstButStr = _T("");
	bReadingHID = false; bWriteHIDReq = false; bWriteHIDReqGranted = false;

	pReceiveThread = AfxBeginThread(ReceiveFunction, this);
    if(pReceiveThread) pReceiveThread->SuspendThread();

	OnDeviceChange(0, NULL);
    if(RHandle == NULL)
	   SetDeviceAttachState(GN_DEVICE_NOT_ATTACHED);	

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSendReceiveHIDDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSendReceiveHIDDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSendReceiveHIDDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

LRESULT CSendReceiveHIDDlg::GetHid( WPARAM wParam, LPARAM lParam ) 
{
	m_VolumeStaticString = "HID Recieved";
	UpdateData(FALSE);
	return 0;
}

HANDLE CSendReceiveHIDDlg::OpenUSBinterface() 
{
	struct _GUID GUID;
	SP_INTERFACE_DEVICE_DATA DeviceInterfaceData;
	struct {DWORD cbSize; char DevicePath[256];} FunctionClassDeviceData;
	int Device;
	HANDLE PnPHandle;
	unsigned long BytesReturned;
	BOOL Success;

	HANDLE Handle;
	HidD_GetHidGuid(&GUID);

// Get a handle for the Plug and Play node and request currently active devices
	PnPHandle = SetupDiGetClassDevs(&GUID, NULL, NULL, DIGCF_PRESENT|DIGCF_INTERFACEDEVICE);
	if (int(PnPHandle) == -1)
		return NULL; 
     // Lets look for a maximum of 20 Devices
	Handle = NULL;
	for (Device = 0; (Device < 20); Device++) {
        // Initialize our data
		DeviceInterfaceData.cbSize = sizeof(DeviceInterfaceData);
        // Is there a device at this table entry
		Success = SetupDiEnumDeviceInterfaces(PnPHandle, NULL, &GUID, Device, &DeviceInterfaceData);
		if (Success) {
            // There is a device here, get it's name
			FunctionClassDeviceData.cbSize = 5;
			Success = SetupDiGetDeviceInterfaceDetail(PnPHandle, &DeviceInterfaceData, 
				(PSP_INTERFACE_DEVICE_DETAIL_DATA)&FunctionClassDeviceData, 256, &BytesReturned, NULL);
			if (!Success) 
				return NULL; 
            // Can now open this Device
			Handle = CreateFile(FunctionClassDeviceData.DevicePath, GENERIC_READ|GENERIC_WRITE, 
					FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
			if (Handle == INVALID_HANDLE_VALUE){
				Handle = NULL;
			}else{
		        HidD_GetAttributes(Handle, &Attributes);
				if (Attributes.VendorID == GN_VENDOR_ID) {
                    if (HidPreparsedData != NULL)
					   HidD_FreePreparsedData(HidPreparsedData);
					HidD_GetPreparsedData(Handle, &HidPreparsedData);
					HidP_GetCaps(HidPreparsedData ,&Capabilities);
                    UsageLength= HidP_MaxUsageListLength(HidP_Input, 0, HidPreparsedData);
	                if (pButtonList != NULL) delete pButtonList;
					pButtonList = (PUSAGE_AND_PAGE)malloc(UsageLength * sizeof(USAGE_AND_PAGE));
					break;
				}else{
  				    Handle = NULL;
				}
			}
		} // if (SetupDiEnumDeviceInterfaces . .
	} // for (Device = 0; (Device < 20); Device++)
	SetupDiDestroyDeviceInfoList(PnPHandle);
    return Handle;
}

BOOL CSendReceiveHIDDlg::OnDeviceChange(UINT nEventType, DWORD_PTR dwData)
{
	static HANDLE HidDevHandle;

	// Check if a GN device is attached or deatached
	HidDevHandle= OpenUSBinterface();
	if (HidDevHandle != NULL) {
		CloseHandle(HidDevHandle);
		if(RHandle == NULL) {
			RHandle = OpenUSBinterface();
			if(pReceiveThread) pReceiveThread->ResumeThread();
            SetDeviceAttachState(GN_DEVICE_ATTACHED);	
		}
		if(SHandle == NULL) {
			SHandle = OpenUSBinterface();
            if(!pBlinkThread) {
			    pBlinkThread = AfxBeginThread(BlinkAllLEDs, this);
			}
		}
	}else {
		if(RHandle != NULL) {
			if(pReceiveThread) pReceiveThread->SuspendThread();
			CloseHandle(RHandle);
			RHandle = NULL;
			SetDeviceAttachState(GN_DEVICE_DEATTACHED);	
		}
		if(SHandle != NULL) {
			CloseHandle(SHandle);
			SHandle = NULL;
		}
	}
	return 0;
}

UINT CSendReceiveHIDDlg::ReceiveFunction( LPVOID pParam )
{
	CSendReceiveHIDDlg *pDlg = (CSendReceiveHIDDlg *) pParam;
	char ReportBuffer[256];
	unsigned long BytesRead;

	// Read report events from a GN USB HID device 
	while(1) {
		pDlg->bReadingHID = true;
		if (ReadFile(pDlg->RHandle, ReportBuffer, 
			         pDlg->Capabilities.InputReportByteLength, 
					 &BytesRead, NULL)) {

		    if(ReportBuffer[1] & GREEN_BUT_PRESSED){
				if(pDlg->GreenLedOn) { 
					pDlg->SendMessage(WM_SET_LED, GB_GREEN_LED_OFF);
				}
				else {
					pDlg->SendMessage(WM_SET_LED, GB_GREEN_LED_ON);
				}
			}
			if(ReportBuffer[1] & WHITE_BUT_PRESSED){
				switch(pDlg->ButtonBState) {
					case 0 : { 
						pDlg->SendMessage(WM_SET_LED, WB_WHITE_LED_ON);
						pDlg->ButtonBState = 1;
						break;
					}
					case 1 : { 
						pDlg->SendMessage(WM_SET_LED, WB_WHITE_LED_OFF);
						pDlg->SendMessage(WM_SET_LED, WB_BLUE_LED_ON);
						pDlg->ButtonBState = 2;
						break;
					}
					case 2 : { 
						pDlg->SendMessage(WM_SET_LED, WB_BLUE_LED_OFF);
						pDlg->SendMessage(WM_SET_LED, WB_GREEN_LED_ON);
						pDlg->ButtonBState = 3;
						break;
					}
					case 3 : { 
						pDlg->SendMessage(WM_SET_LED, WB_GREEN_LED_OFF);
						pDlg->ButtonBState = 0;
						break;
					}
					default : break;
				}
			}
			if(ReportBuffer[1] & RED_BUT_PRESSED){
				if(pDlg->RedLedOn) { 
					pDlg->SendMessage(WM_SET_LED, RB_RED_LED_OFF);
				}
				else {
					pDlg->SendMessage(WM_SET_LED, RB_RED_LED_ON);
				}
			}

			pDlg->SendMessage(WM_HID_INPUT, (WPARAM)&ReportBuffer, BytesRead);
	    } else { 
            Sleep(100);
    	}
    	pDlg->bReadingHID = false;
	}
	pDlg->pReceiveThread = NULL;
	return 0;
}

void CSendReceiveHIDDlg::ShowUsage(char *ReportBuffer, unsigned long BytesRead)
{
 	ULONG  TmpUsageLength = UsageLength;
    NTSTATUS ReturnStatus;

	// Show information for usage page and id based on the report input value
	ReturnStatus = HidP_GetUsagesEx(HidP_Input, 0, pButtonList, &TmpUsageLength, 
		                            HidPreparsedData, ReportBuffer, BytesRead);
						 
	if ((ReturnStatus == HIDP_STATUS_SUCCESS) && (TmpUsageLength != 0)){
		m_Usage.Format("0x%0.2X", pButtonList->Usage);
        m_UsagePage.Format("0x%0.2X", pButtonList->UsagePage);

		switch( pButtonList->UsagePage) {
			case USAGE_PAGE_TELEPHONY   :
				switch( pButtonList->Usage) {
					case USAGE_ID_HOOKSWITCH :
						m_VolumeStaticString = _T(" HOOKSWITCH BUTTON");
						break;
					case USAGE_ID_VOICEMAIL :
						m_VolumeStaticString = _T(" VOICEMAIL BUTTON");
						break;
					case USAGE_ID_PHONE_MUTE :
						m_VolumeStaticString = _T(" PHONE MUTE BUTTON");
						break;
					case USAGE_ID_VOLUME_UP :
						m_VolumeStaticString = _T(" ALTERNATE VOLUME UP");
						break;
					case USAGE_ID_VOLUME_DOWN :
						m_VolumeStaticString = _T(" ALTERNATE VOLUME DOWN");
						break;
					default :
						m_VolumeStaticString = _T(" ");
						break;
				}
				break;
			case USAGE_PAGE_CONSUMER   :
				switch( pButtonList->Usage) {
					case USAGE_ID_VOLUME_UP :
						m_VolumeStaticString = _T(" MAIN VOLUME UP");
						break;
					case USAGE_ID_VOLUME_DOWN :
						m_VolumeStaticString = _T(" MAIN VOLUME DOWN");
						break;
					case USAGE_ID_FIRE : 
						m_VolumeStaticString = _T(" FIRE BUTTONS");
						break;
					default :
						m_VolumeStaticString = _T(" ");
						break;
				}
				break;
			default :
				m_VolumeStaticString = _T(" ");
				break;
		}
	}else{
        m_Usage = _T("");
	    m_UsagePage = _T("");		
	}
}

LRESULT CSendReceiveHIDDlg::OnHidInput( WPARAM wParam, LPARAM lParam  )
{
	char *ReportBuffer      = (char *) wParam;
	unsigned long BytesRead = lParam;

	UpdateData(TRUE);

	/* Pressed buttons info 
	switch((unsigned char) ReportBuffer[1]) {
		case BLUE_BUT_MAIN_VOL_DOWN :
			m_VolumeStaticString = _T(" MAIN VOLUME DOWN");
			break;
		case BLUE_BUT_MAIN_VOL_UP :
			m_VolumeStaticString = _T(" MAIN VOLUME UP");
			break;
		case GREEN_BUT_PRESSED :
            FirstButStr          = _T(" GREEN");
			m_VolumeStaticString = _T(" GREEN BUTTON");
			break;
		case MORE_BUT_REPEAT :
			m_VolumeStaticString = _T(" MORE BUTTONS REPEAT");
			break;
		case WHITE_BUT_PRESSED :
            FirstButStr          = _T(" WHITE");
			m_VolumeStaticString = _T(" WHITE BUTTON");
			break;
		case RED_BUT_PRESSED :
            FirstButStr          = _T(" RED");
			m_VolumeStaticString = _T(" RED BUTTON");
			break;
		case GREEN_BUT_PRESSED_SEC :
			m_VolumeStaticString = FirstButStr + _T(" + GREEN BUTTON");
			break;
		case WHITE_BUT_PRESSED_SEC :
			m_VolumeStaticString = FirstButStr + _T(" + WHITE BUTTON");
			break;
		case RED_BUT_PRESSED_SEC :
			m_VolumeStaticString = FirstButStr + _T(" + RED BUTTON");
			break;
		case BLUE_BUT_ALTR_VOL_DOWN :
			m_VolumeStaticString = _T(" ALTERNATE VOLUME DOWN");
			break;
		case BLUE_BUT_ALTR_VOL_UP :
			m_VolumeStaticString = _T(" ALTERNATE VOLUME UP");
			break;
		default :
			break;
	}
	End of pressed buttons info */

	m_ReceiveReport.Format("0x%0.2X", (unsigned char) ReportBuffer[1]);
    ShowUsage(ReportBuffer, BytesRead);
	UpdateData(FALSE);
 
	StartCleanVolumeThread();
    StartCleanHIDThread();
	return 0;
}

void CSendReceiveHIDDlg::WriteHid(char *bytes)
{
	unsigned long BytesWritten;
    char ReportValue = bytes[1];
 
	// Write a report event to the connected GN USB HID device
	if (WriteFile(SHandle, bytes, 2, &BytesWritten, NULL)) {
		switch (ReportValue) {
			case GB_GREEN_LED_ON  :	
						m_GreenLED.Depress(true);
					    GreenLedOn = TRUE;
						break;
			case GB_GREEN_LED_OFF :	
						m_GreenLED.Depress(false);
					    GreenLedOn = FALSE;
						break;
			case WB_WHITE_LED_ON :	
						m_WhiteLED.Depress(true);
						break;
			case WB_WHITE_LED_OFF :	
						m_WhiteLED.Depress(false);
						break;
			case WB_BLUE_LED_ON :	
						m_BlueLED.Depress(true);
						break;
			case WB_BLUE_LED_OFF:	
						m_BlueLED.Depress(false);
						break;
			case WB_GREEN_LED_ON :	
						m_GreenLED2.Depress(true);
						break;
			case WB_GREEN_LED_OFF :	
						m_GreenLED2.Depress(false);
						break;
			case RB_RED_LED_ON :	
						m_RedLED.Depress(true);
					    RedLedOn = TRUE;
						break;
			case RB_RED_LED_OFF :	
						m_RedLED.Depress(false);
					    RedLedOn = FALSE;
						break;
			case SIDETONE_DISABLE :	
					    m_DisableSidetone = TRUE;
						break;
			case SIDETONE_ENABLE :	
					    m_DisableSidetone = FALSE;
						break;
			default :	break;
		}
	} else {
//	    OnDeviceChange(0, NULL);
	}
}

LRESULT CSendReceiveHIDDlg::OnSetLED( WPARAM wParam, LPARAM lParam )
{
	char bytes[] = { 0x00, 0x00 }; 

	// Write changed LED status as a report event to the connected GN USB HID device
	bytes[1] = ((int) wParam);
    WriteHid(bytes);
	return 0;
}

LRESULT CSendReceiveHIDDlg::OnSetSideTone( WPARAM wParam, LPARAM lParam )
{
	char bytes[] = { 0x00, 0x00 }; 

	// Write changed SideTone selection as a report event to the connected GN USB HID device
	bytes[1] = ((int) wParam);
    WriteHid(bytes);
	return 0;
}

void CSendReceiveHIDDlg::OnSendHidButton()
{
	char bytes[] = { 0x00, 0x01 };
	int tempInt = 0;

	// Write user input as a report event to the connected GN USB HID device
	UpdateData(TRUE);
	sscanf(m_SendEditHIDStr, "%x", &tempInt);
	memcpy(&bytes[1], &tempInt, 1);
    WriteHid(bytes);
    UpdateData(FALSE);
}

void CSendReceiveHIDDlg::OnGreenbutton()
{
	// Green LED button activated
	if(GreenLedOn) { 
		SendMessage(WM_SET_LED, GB_GREEN_LED_OFF);
	}
	else {
		SendMessage(WM_SET_LED, GB_GREEN_LED_ON);
	}
}

void CSendReceiveHIDDlg::OnBnClickedTogglebutton()
{
	// Toggle LED button activated
	switch(ButtonBState) {
		case 0 : { 
			SendMessage(WM_SET_LED, WB_WHITE_LED_ON);
			ButtonBState = 1;
			break;
		}
		case 1 : { 
			SendMessage(WM_SET_LED, WB_WHITE_LED_OFF);
			SendMessage(WM_SET_LED, WB_BLUE_LED_ON);
			ButtonBState = 2;
			break;
		}
		case 2 : { 
			SendMessage(WM_SET_LED, WB_BLUE_LED_OFF);
			SendMessage(WM_SET_LED, WB_GREEN_LED_ON);
			ButtonBState = 3;
			break;
		}
		case 3 : { 
			SendMessage(WM_SET_LED, WB_GREEN_LED_OFF);
			ButtonBState = 0;
			break;
		}
		default : break;
	}
}

void CSendReceiveHIDDlg::OnRedbutton()
{
    // Red LED button activated
	if(RedLedOn) { 
		SendMessage(WM_SET_LED, RB_RED_LED_OFF);
	}
	else {
		SendMessage(WM_SET_LED, RB_RED_LED_ON);
	}
}

void CSendReceiveHIDDlg::OnBnClickedSidetone()
{
	UpdateData(TRUE);
	if (m_DisableSidetone){
		SendMessage(WM_SET_SIDETONE, SIDETONE_DISABLE);
	}else{
		SendMessage(WM_SET_SIDETONE, SIDETONE_ENABLE);
	}
}

void CSendReceiveHIDDlg::OnBnClickedOk()
{
    // Exit button activated
	Deallocate();
	OnOK();
}

void CSendReceiveHIDDlg::OnClose()
{
	Deallocate();
	CDialog::OnClose();
}

void CSendReceiveHIDDlg::SetDeviceAttachState( int AttachState ) 
{
    // Show information telling if a device is attached or deattached and 
	// reset or set control parameters 
	UpdateData(TRUE);
	switch(AttachState) {
		case GN_DEVICE_ATTACHED   :
			m_VolumeStaticString = _T(" DEVICE ATTACHED");
			m_GreenButton.EnableWindow(true);
			m_ToggleButton.EnableWindow(true);
			m_RedButton.EnableWindow(true);
			m_SendHid.EnableWindow(true);
			m_SendEditHID.EnableWindow(true);
            m_SideToneCtrl.EnableWindow(true);
			m_VendorID.Format("0x%0.4X", Attributes.VendorID);
			m_ProductID.Format("0x%0.4X", Attributes.ProductID);
			m_BCD_Device.Format("0x%0.4X", Attributes.VersionNumber);
			break;
		case GN_DEVICE_DEATTACHED :
			m_VolumeStaticString = _T(" DEVICE DEATTACHED");
			m_VendorID = _T("");
			m_ProductID = _T("");
			m_BCD_Device = _T("");
            m_DisableSidetone = FALSE;
			GreenLedOn = FALSE;
			RedLedOn = FALSE;
			ButtonBState = 0;
			m_GreenLED.Depress(false);
			m_WhiteLED.Depress(false);
			m_BlueLED.Depress(false);
			m_GreenLED2.Depress(false);
			m_RedLED.Depress(false);
			m_GreenButton.EnableWindow(false);
			m_ToggleButton.EnableWindow(false);
			m_RedButton.EnableWindow(false);
			m_SendHid.EnableWindow(false);
			m_SendEditHID.EnableWindow(false);
            m_SideToneCtrl.EnableWindow(false);
			break;
		case GN_DEVICE_NOT_ATTACHED   :
			m_VolumeStaticString = _T(" DEVICE NOT ATTACHED");
			m_GreenButton.EnableWindow(false);
			m_ToggleButton.EnableWindow(false);
			m_RedButton.EnableWindow(false);
			m_SendHid.EnableWindow(false);
			m_SendEditHID.EnableWindow(false);
            m_SideToneCtrl.EnableWindow(false);
			break;
		default :
			break;
	}
	UpdateData(FALSE);
}

UINT CSendReceiveHIDDlg::BlinkAllLEDs( LPVOID pParam )
{
	CSendReceiveHIDDlg *pDlg = (CSendReceiveHIDDlg *) pParam;

	// Turn on Green Led
	pDlg->SendMessage(WM_SET_LED, GB_GREEN_LED_ON);
	pDlg->SendMessage(WM_SET_LED, GB_GREEN_LED_ON);
	Sleep(50);

	for(int n=0; n<2; n++) {

		// Turn off Green Led. Turn on Blue Led
		pDlg->SendMessage(WM_SET_LED, GB_GREEN_LED_OFF);
		pDlg->SendMessage(WM_SET_LED, WB_WHITE_LED_OFF);
		Sleep(50);

		// Turn off Blue Led. Turn on Red Led
		pDlg->SendMessage(WM_SET_LED, WB_BLUE_LED_OFF);
		pDlg->SendMessage(WM_SET_LED, WB_GREEN_LED_OFF);
		pDlg->SendMessage(WM_SET_LED, RB_RED_LED_ON);
		Sleep(50);

		// Turn off Red Led. Turn on Blue Led
		pDlg->SendMessage(WM_SET_LED, RB_RED_LED_OFF);
		pDlg->SendMessage(WM_SET_LED, WB_BLUE_LED_ON);
		Sleep(50);

		// Turn off Blue Led. Turn on Green Led
		pDlg->SendMessage(WM_SET_LED, WB_BLUE_LED_OFF);
		pDlg->SendMessage(WM_SET_LED, WB_GREEN_LED_OFF);
		pDlg->SendMessage(WM_SET_LED, GB_GREEN_LED_ON);
		Sleep(50);
	}
	pDlg->SendMessage(WM_SET_LED, GB_GREEN_LED_OFF);
	pDlg->SendMessage(WM_SET_SIDETONE, SIDETONE_ENABLE);
	pDlg->pBlinkThread = NULL;
	return 0;
}

void CSendReceiveHIDDlg::StartCleanVolumeThread()
{
	if(pCleanVolume) {
		pCleanVolume->SuspendThread();
		pCleanVolume->Delete(); //ExitInstance();// SuspendThread();
	}
	pCleanVolume = AfxBeginThread(CleanVolumeString, this);
}

void CSendReceiveHIDDlg::StartCleanHIDThread()
{
	if(pCleanHID) {
		pCleanHID->SuspendThread();
		pCleanHID->Delete(); //ExitInstance();// SuspendThread();
	}
	pCleanHID = AfxBeginThread(CleanHIDString, this);
}

LRESULT CSendReceiveHIDDlg::OnClearStrings( WPARAM wParam, LPARAM lParam ) 
{
	UpdateData(TRUE);
	switch( ((int) wParam)) {
		case CLEAR_EVENT_STRING :
			m_VolumeStaticString = "";
			break;
		case CLEAR_VALUE_STRINGS :
			m_Usage = _T("");		
			m_UsagePage = _T("");		
			m_ReceiveReport = _T("");
			break;
		default :
			break;
	}
	UpdateData(FALSE);
	return 0;
}

UINT CSendReceiveHIDDlg::CleanVolumeString( LPVOID pParam ) 
{
	CSendReceiveHIDDlg *pDlg = (CSendReceiveHIDDlg *) pParam;

	Sleep(2000);
	pDlg->SendMessage(WM_CLEAR_STRINGS, CLEAR_EVENT_STRING);
	pDlg->pCleanVolume = NULL;
	return 0;
}

UINT CSendReceiveHIDDlg::CleanHIDString( LPVOID pParam ) 
{
	CSendReceiveHIDDlg *pDlg = (CSendReceiveHIDDlg *) pParam;

	Sleep(2000);
	pDlg->SendMessage(WM_CLEAR_STRINGS, CLEAR_VALUE_STRINGS);
	pDlg->pCleanHID = NULL;
	return 0;
}

void CSendReceiveHIDDlg::Deallocate() 
{
	if(pBlinkThread) {
		pBlinkThread->SuspendThread();
		pBlinkThread->Delete(); //ExitInstance();// SuspendThread();
	}
	if(pReceiveThread) {
		pReceiveThread->SuspendThread();
		pReceiveThread->Delete(); //ExitInstance();// SuspendThread();
	}
	if(pCleanVolume) {
		pCleanVolume->SuspendThread();
		pCleanVolume->Delete(); //ExitInstance();// SuspendThread();
	}
	if(pCleanHID) {
		pCleanHID->SuspendThread();
		pCleanHID->Delete(); //ExitInstance();// SuspendThread();
	}
	if (pButtonList != NULL)
		delete pButtonList;
	if (HidPreparsedData != NULL)
		HidD_FreePreparsedData(HidPreparsedData);
}

void CSendReceiveHIDDlg::OnEnChangeSendedit()
{
	CString tmpString = m_SendEditHIDStr;

	UpdateData(TRUE);
	for (int i=0; i<m_SendEditHIDStr.GetLength(); i++){
		if (((m_SendEditHIDStr[i] < '0') || (m_SendEditHIDStr[i] > '9')) &&
			((m_SendEditHIDStr[i] < 'a') || (m_SendEditHIDStr[i] > 'f')) &&
			((m_SendEditHIDStr[i] < 'A') || (m_SendEditHIDStr[i] > 'F'))){
    		m_SendEditHIDStr = tmpString;
            UpdateData(FALSE);
			return;
		}
	}
}


